/****************************************************************************
* Donohue and Wolfers (2006) 
* Figure 5
* Homicides Before and After the Illinois Moratorium
****************************************************************************/


clear
cd  "..."
use "Illinois.dta", clear

gen lnsaillinois=ln(saillinois)
gen lnsauslessillinois=ln(sauslessil)
reg lnsaillinois lnsauslessil if dt<mdy(1,1,2000)
predict ilhat if dt>=mdy(1,1,2000)
replace ilhat=exp(ilhat)

gen post=dt>=mdy(1,1,2000)
newey lnsaillinois post lnsauslessil, lag(6)
xi: newey lnsaillinois i.post*lnsauslessil, lag(6)
testparm _I*

twoway (line saillinois dt, sort lcolor(cranberry)) (line sauslessil dt, yaxis(2) sort lcolor(navy) lwidth(thin)) (line ilhat dt if dt>=mdy(1,1,2000), sort lpattern(dash) lwidth(medium)), ytitle("Homicide count in Illinois") ylabel(0(20)120, angle(horizontal)) xtitle("") xlabel( 12419 12784 13149 13515 13880 14245 14610 14976 15341 15706, angle(forty_five) format(%dm__CY)) xline(14610, lcolor(black)) ytitle("Homicide count in the US (excluding Illinois)", axis(2)) ylabel(0(300)1800, angle(horizontal) axis(2)) title(Homicide Before and After the Illinois Moratorium) note("Monthly data Jan 1994 - Dec. 2000, seasonally adjusted using X-12") legend(cols(1) order(1 "Illinois (left axis)" 3 "US less IL (right axis)" 2 "Projected homicides in Illinois" "Estimated 1994-1999: ln(Illinois)=-0.9 + 0.72*ln(US less IL)")) legend(position(6) ring(0) region(fcolor(none) lcolor(none))) text(110 15100 "Moratorium begins") xsize(10) ysize(7.5)
gen diff=saillinois-ilhat
twoway (line saillinois dt, sort lcolor(cranberry)) (line sauslessil dt, yaxis(2) sort lcolor(navy) lwidth(thin)) (line ilhat dt if dt>=mdy(1,1,2000), sort lpattern(dash) lwidth(medium)) (bar diff dt, barwidth(30)), ytitle("Monthly homicide count in Illinois") ylabel(0(20)120, angle(horizontal)) xtitle("") xlabel( 12419 12784 13149 13515 13880 14245 14610 14976 15341 15706, angle(forty_five) format(%dm__CY)) xline(14610, lcolor(black)) ytitle("Monthly homicide count in the US (excluding Illinois)", axis(2)) ylabel(0(300)1800, angle(horizontal) axis(2)) title(Homicide Before and After the Illinois Moratorium) note("Monthly data Jan 1994 - Dec. 2000, seasonally adjusted using X-12") legend(cols(1) order(1 "Illinois (left axis)" 4 "US less IL (right axis)" 2 "Projected homicides in Illinois" "Estimated 1994-1999:" "ln(Illinois)=-0.9 + 0.72*ln(US less IL)" 3 "Illinois: Actual homicides less predicted")) legend(position(7) ring(0) region(fcolor(none) lcolor(none))) text(110 15100 "Moratorium begins") xsize(10) ysize(7.5)

